setlocal enabledelayedexpansion

color 0e

:: Set the screen buffer size (width x height)
mode con: cols=160 lines=20

:: Set the window size (width x height)
mode con: cols=40 lines=10

:: Check if a file path is provided as an argument
if "%~1"=="" (
    echo No file path provided.
    pause
    exit
)

:: Get the path, name, and extension of the provided Excel file
set "excelFile=%~1"
for %%i in ("!excelFile!") do set "excelPath=%%~dpi"
for %%i in ("!excelFile!") do set "excelName=%%~ni"
for %%i in ("!excelFile!") do set "excelExt=%%~xi"

:: Check if the file extension is .xls
if /I "!excelExt!"==".xls" (
    :: Convert the .xls file to .xlsx using Microsoft Office's default tools
    echo Converting the Excel file to XLSX format...
    "C:\Program Files\Microsoft Office\Office16\excelcnv.exe" -oice "!excelFile!" "!excelPath!!excelName!.xlsx"

    :: Update the file path and extension variables
    set "excelFile=!excelPath!!excelName!.xlsx"
    set "excelExt=.xlsx"
)

:: Create a new Excel file name with _temiz_ prefix
set "newExcelName=_temiz_!excelName!"

:: Duplicate the original Excel file and rename it with _temiz_ prefix
copy "!excelFile!" "!excelPath!!newExcelName!!excelExt!"

:: Rename the copy to .zip
ren "!excelPath!!newExcelName!!excelExt!" "!newExcelName!.zip"

:: Create a temporary directory
set "tempDir=%TEMP%\ExcelTemp"
mkdir "!tempDir!" 2>nul

:: Extract the contents of the Excel file (now a .zip)
cd "!tempDir!"
powershell -command "Expand-Archive -Path '!excelPath!!newExcelName!.zip' -DestinationPath '!tempDir!' -Force"

:: Check if the xl\workbook.xml file exists
if exist "!tempDir!\xl\workbook.xml" (
    :: Clear defined names in workbook.xml
    powershell -command "(Get-Content -Path '!tempDir!\xl\workbook.xml') -replace '(?s)<definedNames>.*?</definedNames>', '' | Set-Content -Path '!tempDir!\xl\workbook.xml'"

    :: Repack the contents into a new .zip
    cd "!tempDir!"
    powershell -command "Compress-Archive -Path '*' -DestinationPath '!excelPath!!newExcelName!.zip' -Force"
    
    :: Rename the file extension back to .xlsx
    ren "!excelPath!!newExcelName!.zip" "!newExcelName!.xlsx"
) else (
    echo Workbook.xml not found in the Excel file.
)

:: Clean up temporary directory
cd ..
rmdir /s /q "!tempDir!"
